% to create examples on weighted average, interval weighted average, FWA
% and LWA.
% Dongrui WU (dongruiw@usc.edu), 5/12/2008

clc
clear all
close all

% AWA
X=[1 3 5 7 9];
W=[2 1 6 4 8];
% IWA
devXI=[0.5 0.5 1.2 1.2 1.3 1.3 1.5 1.5 0.8 0.8] ; %% deviation of XI from X.
devWI=[1 1 0.4 0.4 0.9 0.9 1.6 1.6 1 1]; %% deviation of WI from W.
% LWA
k=0.5;
devXL=k*devXI(1:2:10)';
devWL=k*devWI(1:2:10)';

%% AWA
WA=sum(X.*W)/sum(W)
N=length(X);

%% IWA
XI(:,1)=X'-devXI([1,3,5,7,9])';
XI(:,2)=X'+devXI([2,4,6,8,10])';
WI(:,1)=W'-devWI([1,3,5,7,9])';
WI(:,2)=W'+devWI([2,4,6,8,10])';
IWAl=EKM(XI(:,1), WI(:,1), WI(:,2),-1);
IWAr=EKM(XI(:,2), WI(:,1), WI(:,2),1);
IWAmean=(IWAl+IWAr)/2;
[IWAl, IWAr]

%% FWA
XF=[XI(:,1) X' XI(:,2)];
WF=[WI(:,1) W' WI(:,2)];
m=length(XF);
n=21;
delta=1/(n-1);
for k=1:n
    for i=1:m
        a(i)=XF(i,1)+(XF(i,2)-XF(i,1))*(k-1)*delta;
        b(i)=XF(i,3)-(XF(i,3)-XF(i,2))*(k-1)*delta;
        c(i)=WF(i,1)+(WF(i,2)-WF(i,1))*(k-1)*delta;
        d(i)=WF(i,3)-(WF(i,3)-WF(i,2))*(k-1)*delta;
    end
    FWAl(k)=EKM(a,c,d,-1);
    FWAr(k)=EKM(b,c,d,1);
end
FWAcentroid=sum([FWAl FWAr(1:n-1)].*[0:n-1 0:n-2])/sum([0:n-1 0:n-2]);
temp=([FWAl FWAr(n-1:-1:1)]-FWAcentroid).*([FWAl FWAr(n-1:-1:1)]-FWAcentroid);
FWAvariance=sum(temp.*[0:n-1 n-2:-1:0]/(n-1))/(2*n-1);

% figure
% set(gcf,'DefaulttextFontName','times new roman');
% set(gcf,'DefaultaxesFontName','times new roman');
% set(gcf,'DefaulttextFontAngle','italic');
% set(gcf,'DefaulttextFontSize',12);
% set(gcf,'DefaultlineLineWidth',1);
% set(gcf,'DefaultaxesLineWidth',1);
% subplot(311)
% for i=1:N
%     plot(XF(i,:),[0 1 0],'linewidth',1.5);
%     text(XF(i,2)-0.1, 1.15, ['X_' num2str(i)]);
%     hold on
% end
% axis([0,11,0,1.4]);
% set(gca,'xtick',[0:10]);
% box off
% text(10.8,-0.1,'x');
% text(-0.4,1.3,'u');
% arrow([0,0],[11,0],0.13,pi/10,0.5,[0 0 0],'-');
% arrow([0,0.8],[0,1.4],0.12,pi/9,0.5,[0 0 0],'-');
% saveas(gcf,'FWAx.eps');
% 
% figure
% set(gcf,'DefaulttextFontName','times new roman');
% set(gcf,'DefaultaxesFontName','times new roman');
% set(gcf,'DefaulttextFontAngle','italic');
% set(gcf,'DefaulttextFontSize',12);
% set(gcf,'DefaultlineLineWidth',1);
% set(gcf,'DefaultaxesLineWidth',1);
% subplot(312)
% for i=1:N
%     plot(WF(i,:),[0 1 0],'linewidth',1.5);
%     text(WF(i,2)-0.1, 1.15, ['W_' num2str(i)]);
%     hold on
% end
% axis([0,11,0,1.4]);
% set(gca,'xtick',[0:10]);
% box off
% text(10.8,-0.1,'w');
% text(-0.4,1.3,'u');
% arrow([0,0],[11,0],0.13,pi/10,0.5,[0 0 0],'-');
% arrow([0,0.8],[0,1.4],0.12,pi/9,0.5,[0 0 0],'-');
% saveas(gcf,'FWAw.eps');
% 
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultlineLineWidth',1);
set(gcf,'DefaultaxesLineWidth',1);
subplot(3,1.5,1)
plot([FWAl FWAr(n:-1:1)],[0:n-1 n-1:-1:0]*delta,'linewidth',1.5);
text('Interpreter','latex','String','$$Y_{FWA}$$','Position',[FWAl(n)-.5,1.15]);
axis([0,11,0,1.4]);
set(gca,'xtick',0:10);
box off
text(11.2,0,'y');
text('Interpreter','latex','String','$$\mu_{Y_{FWA}}(y)$$','Position',[0.2 1.3]);
arrow([0,0],[11,0],0.1,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.1,pi/10,0.5,[0 0 0],'-');
saveas(gcf,'FWAy.eps');

%% LWA
XL=[XF(:,1)-devXL XF(:,2) XF(:,3)+devXL XF(:,1)+devXL XF(:,2) XF(:,3)-devXL];
WL=[WF(:,1)-devWL WF(:,2) WF(:,3)+devWL WF(:,1)+devWL WF(:,2) WF(:,3)-devWL];
for k=1:n
    for i=1:m
        al(i)=XL(i,1)+(XL(i,2)-XL(i,1))*(k-1)*delta;
        br(i)=XL(i,3)-(XL(i,3)-XL(i,2))*(k-1)*delta;
        cl(i)=WL(i,1)+(WL(i,2)-WL(i,1))*(k-1)*delta;
        dr(i)=WL(i,3)-(WL(i,3)-WL(i,2))*(k-1)*delta;
        ar(i)=XL(i,4)+(XL(i,5)-XL(i,4))*(k-1)*delta;
        bl(i)=XL(i,6)-(XL(i,6)-XL(i,5))*(k-1)*delta;
        cr(i)=WL(i,4)+(WL(i,5)-WL(i,4))*(k-1)*delta;
        dl(i)=WL(i,6)-(WL(i,6)-WL(i,5))*(k-1)*delta;
    end
    LWALl(k)=EKM(ar,cr,dl,-1);
    LWALr(k)=EKM(bl,cr,dl,1);
    LWAUl(k)=EKM(al,cl,dr,-1);
    LWAUr(k)=EKM(br,cl,dr,1);
end

% Compute the centroid of LWA
d=(LWAUl(n)-LWAUl(1))/(n-1);
xs=LWAUl(1):d:LWAUr(1);
for i=1:n
    for j=1:n-1
        if xs(i)>=LWAUl(j) & xs(i)<=LWAUl(j+1)
            UMF(i)=(j-1)*delta+delta*(xs(i)-LWAUl(j))/(LWAUl(j+1)-LWAUl(j));
            break
        end
    end
    for j=1:n-1
        if xs(i)>=LWALl(j) & xs(i)<=LWALl(j+1)
            LMF(i)=(j-1)*delta+delta*(xs(i)-LWALl(j))/(LWALl(j+1)-LWALl(j));
            break
        end
            LMF(i)=0;
    end
end

for i=n+1:length(xs)
    for j=1:n-1
        if xs(i)>=LWAUr(j+1) & xs(i)<=LWAUr(j)
            UMF(i)=(j-1)*delta+delta*(LWAUr(j)-xs(i))/(LWAUr(j)-LWAUr(j+1));
            break
        end
    end
    for j=1:n-1
        if xs(i)>=LWALr(j+1) & xs(i)<=LWALr(j)
            LMF(i)=(j-1)*delta+delta*(LWALr(j)-xs(i))/(LWALr(j)-LWALr(j+1));
            break
        end
            LMF(i)=0;
    end
end
LWACl=EKM(xs,LMF,UMF,-1)
LWACr=EKM(xs,LMF,UMF,1)
LWAc=(LWACl+LWACr)/2;
temp=(xs-LWAc).*(xs-LWAc);
LWAvl=sum(temp.*LMF)/length(LMF);
LWAvr=sum(temp.*UMF)/length(UMF);

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultlineLineWidth',1);
set(gcf,'DefaultaxesLineWidth',1);
subplot(3,1.5,1)
for i=1:N
    fill(XL(i,:),[0 1 0 0 1 0],[0.9,0.9,0.9]);
    hold on
end
for i=1:N
    plot(XL(i,:),[0 1 0 0 1 0],'linewidth',1.5);
    text('Interpreter','latex','String',['$$\widetilde{X}_' num2str(i) '$$'],'Position',[XL(i,2)-0.22 1.15]);
end
axis([0,11,0,1.4]);
set(gca,'xtick',0:10);
box off
text(11.2,0,'x');
text(0.2,1.33,'u');
arrow([0,0],[11,0],0.1,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.1,pi/9,0.5,[0 0 0],'-');
saveas(gcf,'LWAx.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultlineLineWidth',1);
set(gcf,'DefaultaxesLineWidth',1);
subplot(3,1.5,1)
for i=1:N
    fill(WL(i,:),[0 1 0 0 1 0],[0.9,0.9,0.9]);
    hold on
end
for i=1:N
    plot(WL(i,:),[0 1 0 0 1 0],'linewidth',1.5);
        text('Interpreter','latex','String',['$$\widetilde{W}_' num2str(i) '$$'],'Position',[WL(i,2)-0.22 1.15]);
end
axis([0,11,0,1.4]);
set(gca,'xtick',0:10);
box off
text(11.2,0,'w');
text(0.2,1.33,'u');
arrow([0,0],[11,0],0.1,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.1,pi/9,0.5,[0 0 0],'-');
saveas(gcf,'LWAw.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultlineLineWidth',1);
set(gcf,'DefaultaxesLineWidth',1);
subplot(3,1.5,1)
fill([LWAUl LWAUr(n:-1:1) LWALr LWALl(n:-1:1)],[0:n-1 n-1:-1:0 0:n-1 n-1:-1:0]*delta, [0.9,0.9,0.9]);
hold on
plot([LWALl LWALr(n:-1:1)],[0:n-1 n-1:-1:0]*delta,'linewidth',1.5);
hold on
plot([LWAUl LWAUr(n:-1:1)],[0:n-1 n-1:-1:0]*delta,'linewidth',1.5);
axis([0, 11, 0, 1.4]);
text('Interpreter','latex','String','$$\widetilde{Y}_{LWA}$$','Position',[LWAUl(n)-.5,1.15]);
axis([0,11,0,1.4]);
set(gca,'xtick',0:10);
box off
text(11.2,0,'y');
text(0.2,1.3,'u');
arrow([0,0],[11,0],0.1,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.1,pi/10,0.5,[0 0 0],'-');
saveas(gcf,'LWAy.eps');
